require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

function CloseLoading()
	CloseWindow();
	InsideGame(true);
	PostMessage( CreateNamedMessage( kFadeFromBlack, "ReadyForPrelevel();" ) );
end


function CloseLoadingScreen(loadGame)
	if(IsGameLoaded()) then
		--startTime = GetTimer();
		LevelSetup();
		--[[while(GetTimer() - startTime < 3000) do
			-- do nothing until 3 seconds has passed
		end]]
		PostMessage( CreateNamedMessage( kFadeToBlack, "CloseLoading();" ) );
	else
		QuitToMainMenu();
		--PostMessage( CreateNamedMessage( kFadeToBlack, "SwapToModal( 'scripts/game.lua' );" ) );
	end
end


function GetLessonTip() 
	local maxTipNum = 2;
	local tipNum= random(maxTipNum);
	local tipName = "TIP"..tipNum;
	return tipName;	
end

MakeDialog
{
	name = "loading",
	
	Bitmap{
		x = 0,
		y = 0,
		w = kMax, h = kMax,
		image = "ui/backgrounds/loading",
		
		Text{
			x = 290, y = 273,
			w = 240, h = 55,
			flags = kHAlignCenter + kVAlignCenter,
			label = "loading_loading",
			font = 	{edwardian_medium, 40, WhiteColor},
		},
		--[[Text{
			x = 64, y = 479,
			w = 120, h = 80,
			flags = kHAlignCenter + kVAlignCenter,
			label = "loading_tip",
			font = 	{edwardian_medium, 40, Color(167,31,79)},
		},
		Text{
		    name = "tip_text",
			x = 185, y = 479,
			w = 555, h = 80,
			flags = kHAlignLeft + kVAlignCenter,
			label = GetLessonTip();
			font = 	{edwardian_medium, 20, BlackColor},
		},]]
	},
}

---------------- 
--	Always fade from black and check if we need a game intro popup
EnableWindow("tip_text", false);

PostMessage( CreateNamedMessage( kFadeFromBlack, "CloseLoadingScreen(true);" ) );
InsideGame(false);